#include <bits/stdc++.h>

#define ll long long
#define loop(i, a, b) for(ll i = a; i < b; i++)

using namespace std;

ll fin_prim = -1;
ll fin_sec = -1;

ll to_leaf(const vector<ll> tree[], vector<ll> &leaf, ll prev, ll node) {
    ll ans = 0;
    for(auto x : tree[node]) {
        if (x == prev) continue;
        ans = max(ans, to_leaf(tree, leaf, node, x));
    }
    leaf[node] = ans + 1;
    return ans + 1;
}

ll max_length(const vector<ll> tree[], const vector<ll> &leaf, ll prev, ll node) {
    ll prim = 0;
    ll sec = 0;
    ll ans = 1;
    ll n1 = 0;
    ll n2 = 0;
    for(auto x : tree[node]) {
        if (x == prev) continue;
        if (leaf[x] >= prim) {
            sec = prim;
            prim = leaf[x];
            n2 = n1;
            n1 = x;
        } else if (leaf[x] > sec) {
            sec = leaf[x];
            n2 = x;
        }

        ans = max(ans, max_length(tree, leaf, node, x));
    }

    if (prim + sec > ans && sec != 0) {
        fin_prim = n1;
        fin_sec = n2;
    }

    return max(prim + sec, ans);
}

void get_roots(const vector<ll> tree[], vector<ll> &roots, ll prev, ll node) {
    for(auto x : tree[node]) {
        if (x == prev) continue;
        roots[x] = node;
        get_roots(tree, roots, node, x);
    }
}

ll lowest_child(const vector<ll> tree[], const vector<ll> &leaf, ll prev, ll node) {
    for(auto x : tree[node]) {
        if (x == prev) continue;
        if (leaf[x] == leaf[node] - 1) return lowest_child(tree, leaf, node, x);
    }
    return node;
}

void concat(vector<ll> tree[], const vector<ll> &roots, const vector<ll> &leaf, ll a, ll b) {
    loop(i, 0, tree[a].size()) {
        if (tree[a][i] == roots[a]) {
            tree[a].erase(tree[a].begin() + i);
        }
    }
    loop(i, 0, tree[roots[a]].size()) {
        if (tree[roots[a]][i] == a) {
            tree[roots[a]].erase(tree[roots[a]].begin() + i);
        }
    }

    ll lc = lowest_child(tree, leaf, roots[b], b);
    tree[a].push_back(lc);
    tree[lc].push_back(a);
}


int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    ll t, n, k, a, b;
    cin >> t;

    while(t--) {
        cin >> n >> k;
        vector<ll> tree[n];
        vector<ll> roots(n);

        loop(i, 0, n - 1) {
            cin >> a >> b;
            a--;
            b--;
            tree[b].push_back(a);
            tree[a].push_back(b);
        }
        vector<ll> leaf(n);
        to_leaf(tree, leaf, 0, 0);
        ll dim = max_length(tree, leaf, 0, 0);

        loop(i, 0, k) {
            get_roots(tree, roots, 0, 0);
            concat(tree, roots, leaf, fin_prim, fin_sec);
            to_leaf(tree, leaf, 0, 0);
            dim = max(max_length(tree, leaf, 0, 0), dim);
        }

        cout << dim << "\n";
    }

    return 0;
}